﻿<%@ Page Language="C#" AutoEventWireup="true" MasterPageFile="~/OneColumn.master" CodeBehind="Gantt.aspx.cs" Inherits="GUI.Pages.Gantt" %>

<asp:Content ID="Content3" ContentPlaceHolderID="StylePlaceholder" runat="server" >
<link href="../repository/styles/ganttstyle.css" rel="stylesheet" media="screen" />
</asp:Content>

<asp:Content ID="Content1" ContentPlaceHolderID="Content" runat="server">   
<div class="page-full-main-content">
    <div class="row">
        <div class="col-md-12 col-sm-12">
            <div class="portlet light bordered light-blue">
                <div class="portlet-title">
                    <div class="caption">
                        <span class="caption-subject bold font-dark uppercase" id="pageTitle" runat="server"> 
						<asp:Literal ID="Literal4" runat="server" Text="<%$ Resources:ProjectManagementUI, Gantt_Title %>" /> 
						</span>
                   <asp:HiddenField ID="hdnProjectId" runat="server" />
                        <asp:HiddenField ID="hdnUser" runat="server" />
                        <asp:HiddenField ID="hdnOrdNum" runat="server" /> 
                            <asp:HiddenField ID="hdnTaskdata" runat="server" />   
                        <asp:HiddenField ID="hdnLanguage" runat="server" />   
                        <asp:HiddenField ID="hdnRoles" runat="server" />  
                    </div>
                </div>
                <div class="portlet-body form">
                    <div class="row">

                        <div class="col-md-12">
                            <div class="form-actions right">
                                <asp:Button OnClick="btnKanban_Click" runat="server" ID="btnKanban" CssClass="btn blue" CausesValidation="false" Text="<%$ Resources:ProjectManagementUI, UI_Kanban %>"/>
                                <asp:Button OnClick="btnActivity_Click" runat="server" ID="btnActivity" CssClass="btn blue" CausesValidation="false" Text="<%$ Resources:ProjectManagementUI, UI_Task2 %>"/>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <div class="input-group">
                                 <input name="searchBoxtask" type="text" id="searchBoxtask" autocomplete="off" class="form-control" placeholder='<asp:Literal runat="server" Text="<%$ Resources:ProjectManagementUI, Gantt_searchBoxtask%>" />'>
                                <span class="input-group-btn">
                                    <button id="Pretraga" class="btn red" onclick="javascript:Search_Click();return false;"><i class="fa fa-search"></i></button>            
                                </span>
                            </div>
                        </div>

                        <div class="col-md-3">
                            <strong id="filteringId" runat="server">Filtering: &nbsp; </strong>
			                <label>
				                <input id="zerovalue" runat="server" name="filter" onclick="filter_tasks(this);" type="radio" value="0" checked="true">
				                <span id="altasks" runat="server">All tasks</span>
			                </label>

			                <label>
				                <input id="highvalue" runat="server" name="filter" onclick="filter_tasks(this);" type="radio" value="high">
				                <span id="high" runat="server">High</span>
			                </label>

    			            <label>
				                <input id="lowvalue" runat="server" name="filter" onclick="filter_tasks(this);" type="radio" value="low">
				                <span id="low" runat="server">Low</span>
    			            </label>

			                <label>
				                <input id="mediumvalue" runat="server" name="filter" onclick="filter_tasks(this);" type="radio" value="medium">
				                <span id="medium" runat="server">Medium</span>
			                </label>
                        </div>

                        <div class="col-md-3">
			                <strong id="assigned" runat="server">Asigneed: &nbsp;</strong>
			                <label>
                                <telerik:RadComboBox ID="rcbBlah" runat="server" CheckBoxes="true" Width="300px"
                                    ChangeTextOnKeyBoardNavigation="false" Skin="Bootstrap" OnClientItemChecked="OnClientItemChecked"  OnClientDropDownClosed="MyBlur">
                                    <Items>
                                        <%--<telerik:RadComboBoxItem Text="All" Value="-1"  Checked="true"/>
                                        <telerik:RadComboBoxItem Text="Apple" Value="1" />
                                        <telerik:RadComboBoxItem Text="Carrot" Value="2" />
                                        <telerik:RadComboBoxItem Text="Peach" Value="3" />
                                        <telerik:RadComboBoxItem Text="Pear" Value="4" />
                                        <telerik:RadComboBoxItem Text="Tomato" Value="5" />
                                        <telerik:RadComboBoxItem Text="Zucchini" Value="6" />--%>
                                    </Items>
                                </telerik:RadComboBox>
                            </label>
                        </div>
                        
                        <div class="col-md-3">
                            <strong id="finishedh" runat="server">Finished: &nbsp;</strong>
                            <label>
				                <input name="filterf" onclick="filter_tasks2(this);" type="radio" value="0" checked="true">
				                <span id="alltasks1" runat="server">All tasks</span></label>
                            <label>
				                <input name="filterf" onclick="filter_tasks2(this);" type="radio" value="No">
				                <span id="notfinished" runat="server">Not finished</span></label>
			                 <label>
				                <input name="filterf" onclick="filter_tasks2(this);" type="radio" value="Yes">
				                <span id="finished" runat="server">Finished</span></label>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-3">
                            <input type="button" class="btn blue" ID="ColapseAll" value='<asp:Literal runat="server" Text="<%$ Resources:ProjectManagementUI, Gantt_colapseall%>" />' onclick="zatvoriSve()"/>
                            <input type="button" class="btn blue" ID="ExpandAll" value='<asp:Literal runat="server" Text="<%$ Resources:ProjectManagementUI, Gantt_expandall%>" />' onclick="otvoriSve()"/>
                            <input type="button" class="btn blue" ID="CriticalPath" onclick='updateCriticalPath(this)' value='<asp:Literal runat="server" Text="<%$ Resources:ProjectManagementUI, Gantt_criticalpath %>" />'/>
                               <%-- <asp:Button  OnClick="btnUpdate_Click" runat="server" ID="Button1" CssClass="radius button right" CausesValidation="false" style="display:none" />--%>
                        </div>

                        <div class="col-md-3">
                            <strong  id="zooming" runat="server"> Zooming: &nbsp; </strong>
			                <label>
				                <input name="scales" onclick="zoom_tasks(this)" type="radio" value="week">
				                <span  id="hours" runat="server">Hours</span></label>
			                <label>
				                <input name="scales" onclick="zoom_tasks(this)" type="radio" value="trplweek" checked="true">
				                <span  id="days" runat="server">Days</span></label>
			                <label>
				                <input name="scales" onclick="zoom_tasks(this)" type="radio" value="year">
				                <span  id="months" runat="server">Months</span></label>
    			                <label>
				                <input name="scales" onclick="zoom_tasks(this)" type="radio" value="trplyear">
				                <span  id="year" runat="server">Year</span></label>
                        </div>
                        <div class="col-md-3">
                            <div id="filter_days">
				                <strong  id="display" runat="server"> Display: &nbsp; </strong>
				                <label>
					                <input name="scales_filter" onclick="set_scale_units(this)" type="radio" value="full_week">
					                <span  id="fullweek" runat="server">Full week</span>
					                <input name="scales_filter" onclick="set_scale_units(this)" type="radio" value="work_week">
					                <span  id="workdays" runat="server">Workdays</span>
				                </label>
			                </div>
                        </div>

                        <div class="col-md-3">
                            <div id="filter_hours" style="display: none;">
				                <span>&nbsp; &nbsp; | &nbsp; &nbsp; </span>
				                <strong  id="display1" runat="server"> Display: &nbsp; </strong>
				                <label>
					                <input name="scales_filter" onclick="set_scale_units(this)" type="radio" value="full_day" checked="true">
					                <span id="fullday" runat="server">Full day</span>
					                <input name="scales_filter" onclick="set_scale_units(this)" type="radio" value="work_hours">
					                <span id="officehours" runat="server">Office hours</span>
				                </label>
			                </div>
                        </div>
                    </div>
                    <hr />
                    <div class="row">
                            <div class="col-md-12" style="overflow-x: auto; overflow-y: auto;">
                                <div id="gantt_here" style="min-width: 1280px; height: 650px;"></div>
                            </div>
                        </div>
                </div>
            </div>
        </div>
    </div>
</div>



 
<div id="kendotask">
                              
<div class="row-light">
                               <telerik:RadWindowManager Skin="Bootstrap"
                                  Behaviors="Close" ID="RadWindowManager1" 
                                   Opacity="50" runat="server"  ShowContentDuringLoad="false" ReloadOnShow="true" >
                                    <Windows>
                                        <telerik:RadWindow ID="RadWindow1" Opacity="100" Width="90%" Height="650px" Title="<%$ Resources:ProjectManagementUI, Common_Activity %>" runat="server" CssClass="task-window" EnableViewState = "false" OnClientClose="RefreshParentPage">
                                    
                                        </telerik:RadWindow>
                                     </Windows>
                                </telerik:RadWindowManager>
</div>              
                                 
</div>
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="ScriptPlacerholder" runat="server">
    <script type="text/javascript" src="../Scripts/dhtmlxGanttScripts.js"></script>
    <script type="text/javascript" src="../repository/dhtmlx/ext/dhtmlxgantt_critical_path.js"></script>
    <script type="text/javascript" src="../repository/dhtmlx/ext/dhtmlxgantt_fullscreen.js"></script>
     <script type="text/javascript" src="../repository/dhtmlx/ext/dhtmlxgantt_marker.js"></script>
    <script type="text/javascript" src="../repository/dhtmlx/ext/dhtmlxgantt_tooltip.js"></script>
  <%-- <script type="text/javascript" src="../repository/dhtmlx/ext/ganttscript.js">--%>
   
    <script>
   //document.onreadystatechange = getact();
        //<!-- GANT POCETAK-->
        //var appRoot = HttpRuntime.AppDomainAppVirtualPath.ToString().TrimEnd('/');
        var TO;
        var Idproject = parseInt(document.getElementById("MainContentPlaceHolder_Content_hdnProjectId").value);
        var project = document.getElementById("MainContentPlaceHolder_Content_hdnProjectId").value;
        var jezik = document.getElementById("MainContentPlaceHolder_Content_hdnLanguage").value;
        var parametar = '{ "projectId":"' + Idproject + '" }';
        //gantt.config.touch = "force";
        gantt.config.touch = true;
        gantt.config.smart_rendering = true;
        gantt.config.static_background = true;
        gantt.config.scale_unit = "month";
        gantt.config.date_scale = "%F, %Y";
        gantt.config.duration_unit="day";
        gantt.config.duration_step=1;
        gantt.config.subscales = [
            { unit: "week", step: 1, date: "%W" },
            { unit: "day", step: 1, date: "%D" }
            //,
            //{ unit: "hour", step: 1, format: "%g %a" }
        ];
        gantt.config.scale_height = 66;
        
        gantt.config.xml_date = "%Y-%m-%d %H:%i";
      
       
          
        //alert(jezik);
        if (jezik == "en-US") {
            gantt.config.date_grid = "%Y-%m-%d";
            gantt.config.scale_height = 66;
            //gantt.config.subscales_height = 44;
            gantt.config.columns = [
                { name: "wbs", label: "Ordinal number", width: 80, template: gantt.getWBSCode, resize: true },
                { name: "text", label: "Task name", tree: true, width: 160, resize: true },
                { name: "start_date", label: "Start", align: "center", width: 100, resize: true },
                { name: "duration", label: "Duration", align: "center", width: 80, resize: true },
                { name: "progress", label: "Progress", align: "center", width: 80, resize: true, hide: true },
                { name: "priority", label: "Priority", align: "center", width: 80, resize: true },
                { name: "assigned", label: "Assigned", align: "center", width: 100, resize: true },
            //  { name: "description", label: "Description", align: "center", width: 100, resize: true, hide: true },
                { name: "isfinished", label: "Finished", align: "center", width: 80, hide: true },
                { name: "add", label: "", width: 44 }
            // more columns
                ];
            }
        else if (jezik == "de-DE")
        {
            gantt.config.date_grid = "%d.%m.%Y";
            gantt.config.scale_height = 66;
            //gantt.config.subscales_height = 44;
            gantt.config.columns = [
                { name: "wbs", label: "Ordinalzahl", width: 80, template: gantt.getWBSCode, resize: true },
                { name: "text", label: "Aktivität name", tree: true, width: 160, resize: true },
                { name: "start_date", label: "Start", align: "center", width: 100, resize: true },
                { name: "duration", label: "Dauer", align: "center", width: 80, resize: true },
                { name: "progress", label: "Fortschritt", align: "center", width: 80, resize: true, hide: true },
                { name: "priority", label: "Priorität", align: "center", width: 80, resize: true },
                { name: "assigned", label: "Zugewiesen", align: "center", width: 100, resize: true },
                //  { name: "description", label: "Beschreibung", align: "center", width: 100, resize: true, hide: true },
                { name: "isfinished", label: "Fertig", align: "center", width: 80, hide: true },
                { name: "add", label: "", width: 44 }
                // more columns
            ];
        } else if (jezik == "en-AU") {
            gantt.config.date_grid = "%d.%m.%Y";
            gantt.config.scale_height = 66;
            //gantt.config.subscales_height = 44;
            gantt.config.columns = [
                { name: "wbs", label: "Ordinal number", width: 80, template: gantt.getWBSCode, resize: true },
                { name: "text", label: "Task name", tree: true, width: 160, resize: true },
                { name: "start_date", label: "Start", align: "center", width: 100, resize: true },
                { name: "duration", label: "Duration", align: "center", width: 80, resize: true },
                { name: "progress", label: "Progress", align: "center", width: 80, resize: true, hide: true },
                { name: "priority", label: "Priority", align: "center", width: 80, resize: true },
                { name: "assigned", label: "Assigned", align: "center", width: 100, resize: true },
                //  { name: "description", label: "Description", align: "center", width: 100, resize: true, hide: true },
                { name: "isfinished", label: "Finished", align: "center", width: 80, hide: true },
                { name: "add", label: "", width: 44 }
            // more columns
            ];
        } else if (jezik == "sr-Latn-RS" || jezik == "hr-HR") {
            gantt.config.date_grid = "%d.%m.%Y";
            gantt.config.scale_height = 66;
            //gantt.config.subscales_height = 44;
            gantt.config.columns = [
                { name: "wbs", label: "Redni broj", width: 80, template: gantt.getWBSCode, resize: true },
        { name: "text", label: "Naziv aktivnosti", tree: true, width: 160, resize: true },
        { name: "start_date", label: "Početak", align: "center", width: 100, resize: true },
        { name: "duration", label: "Trajanje", align: "center", width: 80, resize: true },
       { name: "progress", label: "Progres", align: "center", width: 80, resize: true, hide: true },
       { name: "priority", label: "Prioritet", align: "center", width: 80, resize: true },
       { name: "assigned", label: "Dodjeljen", align: "center", width: 100, resize: true },
       //   { name: "description", label: "Opis", align: "center", width: 100, resize: true, hide: true },
        { name: "isfinished", label: "Završen", align: "center", width: 80, hide: true },
       { name: "add", label: "", width: 44 }
        // more columns
            ];
        }else if (jezik == "es-ES") {
            gantt.config.date_grid = "%d.%m.%Y";
            gantt.config.scale_height = 66;
            //gantt.config.subscales_height = 44;
            gantt.config.columns = [
                { name: "wbs", label: "Número ordinal", width: 80, template: gantt.getWBSCode, resize: true },
        { name: "text", label: "Nombre de la tarea", tree: true, width: 160, resize: true },
        { name: "start_date", label: "Comienzo", align: "center", width: 100, resize: true },
        { name: "duration", label: "Duración", align: "center", width: 80, resize: true },
       { name: "progress", label: "Progreso", align: "center", width: 80, resize: true, hide: true },
       { name: "priority", label: "Prioridad", align: "center", width: 80, resize: true },
       { name: "assigned", label: "Asignado", align: "center", width: 100, resize: true },
       //   { name: "description", label: "Opis", align: "center", width: 100, resize: true, hide: true },
        { name: "isfinished", label: "Terminado", align: "center", width: 80, hide: true },
       { name: "add", label: "", width: 44 }
        // more columns
            ];
        }else if (jezik == "en-GB") {
            gantt.config.date_grid = "%d.%m.%Y";
            gantt.config.scale_height = 66;
            //gantt.config.subscales_height = 44;
            gantt.config.columns = [
                { name: "wbs", label: "Ordinal number", width: 80, template: gantt.getWBSCode, resize: true },
                { name: "text", label: "Task name", tree: true, width: 160, resize: true },
                { name: "start_date", label: "Start", align: "center", width: 100, resize: true },
                { name: "duration", label: "Duration", align: "center", width: 80, resize: true },
                { name: "progress", label: "Progress", align: "center", width: 80, resize: true, hide: true },
                { name: "priority", label: "Priority", align: "center", width: 80, resize: true },
                { name: "assigned", label: "Assigned", align: "center", width: 100, resize: true },
                //  { name: "description", label: "Description", align: "center", width: 100, resize: true, hide: true },
                { name: "isfinished", label: "Finished", align: "center", width: 80, hide: true },
                { name: "add", label: "", width: 44 }
            // more columns
            ];
        }else if (jezik == "sl-SI") {
            gantt.config.date_grid = "%d.%m.%Y";
            gantt.config.scale_height = 66;
            //gantt.config.subscales_height = 44;
            gantt.config.columns = [
                { name: "wbs", label: "Ordinalno število", width: 80, template: gantt.getWBSCode, resize: true },
                { name: "text", label: "Ime opravila", tree: true, width: 160, resize: true },
                { name: "start_date", label: "Začetak", align: "center", width: 100, resize: true },
                { name: "duration", label: "Trajanje", align: "center", width: 80, resize: true },
                { name: "progress", label: "Napredek", align: "center", width: 80, resize: true, hide: true },
                { name: "priority", label: "Prednostna naloga", align: "center", width: 80, resize: true },
                { name: "assigned", label: "Dodeljeno ", align: "center", width: 100, resize: true },
                //  { name: "description", label: "Description", align: "center", width: 100, resize: true, hide: true },
                { name: "isfinished", label: "Dokončano", align: "center", width: 80, hide: true },
                { name: "add", label: "", width: 44 }
            // more columns
            ];
        }else if (jezik == "it-IT") {
            gantt.config.date_grid = "%d.%m.%Y";
            gantt.config.scale_height = 66;
            //gantt.config.subscales_height = 44;
            gantt.config.columns = [
                { name: "wbs", label: "Numero ordinale", width: 80, template: gantt.getWBSCode, resize: true },
                { name: "text", label: "Nome dell'attività", tree: true, width: 160, resize: true },
                { name: "start_date", label: "Inizio", align: "center", width: 100, resize: true },
                { name: "duration", label: "Durata", align: "center", width: 80, resize: true },
                { name: "progress", label: "Progresso", align: "center", width: 80, resize: true, hide: true },
                { name: "priority", label: "Priorità", align: "center", width: 80, resize: true },
                { name: "assigned", label: "Assegnato", align: "center", width: 100, resize: true },
                //  { name: "description", label: "Description", align: "center", width: 100, resize: true, hide: true },
                { name: "isfinished", label: "Finito", align: "center", width: 80, hide: true },
                { name: "add", label: "", width: 44 }
            // more columns
            ];
        }
        gantt.config.layout = {
            css: "gantt_container",
            cols: [
               {
                   width:644,
                   min_width: 300,
      
                   // adding horizontal scrollbar to the grid via the scrollX attribute
                   rows:[
                    {view: "grid", scrollX: "gridScroll", scrollable: true, scrollY: "scrollVer"}, /*!*/
                    {view: "scrollbar", id: "gridScroll"}  /*!*/
                   ]
               },
               {resizer: true, width: 1},
               {
                   rows:[
                    {view: "timeline", scrollX: "scrollHor", scrollY: "scrollVer"},
                    {view: "scrollbar", id: "scrollHor"}
                   ]
               },
               {view: "scrollbar", id: "scrollVer"}
            ]
           
        };
        gantt.config.open_tree_initially = true;
        gantt.templates.task_class = function (start, end, task) {
            var css = [];
            if (task.type == gantt.config.types.project) {
                css.push("no_drag_progress");
            } 
            return css.join(" ");
        };
        gantt.attachEvent("onLinkClick", function (id) {
            var link = this.getLink(id),
                src = this.getTask(link.source),
                trg = this.getTask(link.target),
                types = this.config.links;

            var first = "", second = "";
            switch (link.type) {
                case types.finish_to_start:
                    if (jezik == "en-US") {
                        first = "finish";
                        second = "start";
                    }
                    else if (jezik == "es-ES") {
                        first = "terminar";
                        second = "empezar";
                    } else if (jezik == "de-DE") {
                        first = "fertig";
                        second = "start";
                    } else if (jezik == "en-AU") {
                        first = "finish";
                        second = "start";
                    } else if (jezik == "sr-Latn-RS" || jezik == "hr-HR" || jezik == "bs-BS") {

                        first = "završi";
                        second = "počela";
                    }
                    else if (jezik == "en-GB") {
                        first = "finish";
                        second = "start";
                    }
                    else if (jezik == "sl-SI") {
                        first = "konča";
                        second = "začne";
                    } else if (jezik == "it-IT") {
                        first = "finire";
                        second = "inizio";
                    }
                    break;
                case types.start_to_start:
                    if (jezik == "en-US") {
                        first = "start";
                        second = "start";
                    } else if (jezik == "es-ES") {
                        first = "empezar";
                        second = "empezar";
                    } else if (jezik == "de-DE") {
                        first = "start";
                        second = "start";
                    } else if (jezik == "en-AU") {
                        first = "start";
                        second = "start";
                    } else if (jezik == "sr-Latn-RS" || jezik == "hr-HR" || jezik == "bs-BS") {

                        first = "počne";
                        second = "počela";
                    }
                    else if (jezik == "en-GB") {
                        first = "start";
                        second = "start";
                    }else if (jezik == "sl-SI") {
                        first = "začne";
                        second = "začne";
                    }else if (jezik == "it-IT") {
                        first = "inizio";
                        second = "inizio";
                    }
                    break;
                case types.finish_to_finish:
                    if (jezik == "en-US") {
                        first = "finish";
                        second = "finish";
                    }
                    else if (jezik == "es-ES") {
                        first = "terminar";
                        second = "terminar";
                    }
                    else if (jezik == "de-DE") {
                        first = "fertig";
                        second = "fertig";
                    } else if (jezik == "en-AU") {
                        first = "finish";
                        second = "finish";
                    } else if (jezik == "sr-Latn-RS" || jezik == "hr-HR" || jezik == "bs-BS") {
                        first = "završi";
                        second = "završila";

                    }
                    else if (jezik == "en-GB") {
                        first = "finish";
                        second = "finish";
                    }else if (jezik == "sl-SI") {
                        first = "konča";
                        second = "konča";
                    }else if (jezik == "it-IT") {
                        first = "finire";
                        second = "finire";
                    }
                    break;
            }
            if (jezik == "en-US") {
                gantt.message("Must " + first + " <b>" + src.text + "</b> to " + second + " <b>" + trg.text + "</b>");
            }
            else if (jezik == "es-ES") {
                gantt.message("Debe " + first + " <b>" + src.text + "</b> to " + second + " <b>" + trg.text + "</b>");
            } 
            else if (jezik == "de-DE") {
                gantt.message("Muss " + first + " <b>" + src.text + "</b> to " + second + " <b>" + trg.text + "</b>");
            } else if (jezik == "en-AU") {
                gantt.message("Must " + first + " <b>" + src.text + "</b> to " + second + " <b>" + trg.text + "</b>");
            } else if (jezik == "en-GB") {
                gantt.message("Must " + first + " <b>" + src.text + "</b> to " + second + " <b>" + trg.text + "</b>");
            } else if (jezik == "sl-SI") {
                gantt.message("Must " + first + " <b>" + src.text + "</b> to " + second + " <b>" + trg.text + "</b>");
            } else if (jezik == "it-IT") {
                gantt.message("Dovere " + first + " <b>" + src.text + "</b> to " + second + " <b>" + trg.text + "</b>");
            } else if (jezik == "sr-Latn-RS" || jezik == "hr-HR" || jezik == "bs-BS") {
                gantt.message("Mora da " + first + " <b>" + src.text + "</b> da bi " + second + " <b>" + trg.text + "</b>");

            }
            
        });
        var gantt_filter = "0";
        var gantt_filter1 = "0";
        var gantt_filter2 = "0";
        var gantt_filter3 = "0";

        gantt.attachEvent("onBeforeTaskDisplay", function (id, task) {
            switch (gantt_filter)
            {
                case "0":
                    switch(gantt_filter1)
                    {
                        case "0":
                            switch(gantt_filter2)
                            {
                                case "0":
                                    switch(gantt_filter3)
                                    {
                                        case "0":
                                            return true;
                                            break;
                                        default:
                                            if (task.text.toLowerCase().includes(gantt_filter3.toLowerCase())) {
                                                return true;
                                            }
                                            return false;
                                            break;
                                    }
                                    break;

                                default:
                                    switch(gantt_filter3)
                                    {
                                        case "0":
                                            if (task.isfinished == gantt_filter2) {
                                                return true;
                                            }
                                            return false;
                                            break;
                                        default:
                                            if (task.text.toLowerCase().includes(gantt_filter3.toLowerCase()) && task.isfinished == gantt_filter2) {
                                                return true;
                                            }
                                            return false;
                                            break;
                                    }
                                    break;
                            }
                            break;

                        default:
                            switch(gantt_filter2)
                            {
                                case "0":
                                    
                                    switch(gantt_filter3)
                                    {
                                        case "0":
                                            if (task.assigned.includes(gantt_filter1)) {
                                                return true;
                                            }
                                            return false;
                                            break;
                                        default:
                                            if (task.text.toLowerCase().includes(gantt_filter3.toLowerCase()) && task.assigned.includes(gantt_filter1)) {
                                                return true;
                                            }
                                            return false;
                                            break;
                                    }
                                    break;

                                default:
                                    switch(gantt_filter3)
                                    {
                                        case "0":
                                            if (task.isfinished == gantt_filter2 && task.assigned.includes(gantt_filter1)) {
                                                return true;
                                            }
                                            return false;
                                            break;
                                        default:
                                            if (task.text.toLowerCase().includes(gantt_filter3.toLowerCase()) && task.isfinished == gantt_filter2 && task.assigned.includes(gantt_filter1)) {
                                                return true;
                                            }
                                            return false;
                                            break;

                                    }

                            }
                            break;
                    }
                    break;

                default:
                    switch(gantt_filter1)
                    {
                        case "0":
                            switch(gantt_filter2)
                            {
                                case "0":
                                    switch(gantt_filter3)
                                    {
                                        case "0":
										
                                            if (task.priority==gantt_filter) {
                                                return true;
                                            }
                                            return false;
                                            break;
                                        default:
                                            if (task.texttoLowerCase().includes(gantt_filter3.toLowerCase()) && task.priority == gantt_filter) {
                                                return true;
                                            }
                                            return false;
                                            break;
                                    }
                                    break;

                                default:
                                    switch(gantt_filter3)
                                    {
                                        case "0":
                                            if (task.isfinished == gantt_filter2 && task.priority==gantt_filter) {
                                                return true;
                                            }
                                            return false;
                                            break;
                                        default:
                                            if (task.text.toLowerCase().includes(gantt_filter3.toLowerCase()) && task.isfinished == gantt_filter2 && task.priority == gantt_filter) {
                                                return true;
                                            }
                                            return false;
                                            break;

                                    }
                                    break;
                            }
                            break;

                        default:
                            switch(gantt_filter2)
                            {
                                case "0":
                                    switch(gantt_filter3)
                                    {
                                        case "0":
                                            if (task.assigned.includes(gantt_filter1) && task.priority==gantt_filter) {
                                                return true;
                                            }
                                            return false;
                                            break;
                                        default:
                                            if (task.text.toLowerCase().includes(gantt_filter3.toLowerCase()) && task.assigned.includes(gantt_filter1) && task.priority == gantt_filter) {
                                                return true;
                                            }
                                            return false;
                                            break;
                                    }
                                    break;

                                default:
                                    switch(gantt_filter3)
                                    {
                                        case "0":
                                            if (task.isfinished == gantt_filter2 && task.assigned.includes(gantt_filter1) && task.priority==gantt_filter) {
                                                return true;
                                            }
                                            return false;
                                            break;
                                        default:
                                            if (task.text.toLowerCase().includes(gantt_filter3.toLowerCase()) && task.isfinished == gantt_filter2 && task.assigned.includes(gantt_filter1) && task.priority == gantt_filter) {
                                                return true;
                                            }
                                            return false;
                                            break;

                                    }
                                    break;
                            }
                            break;
                    }
                    break;

            }  
            
        });

        gantt.templates.scale_cell_class = function (date) {
            if (date.getDay() == 0 || date.getDay() == 6) {
                return "weekend";
            }
        };
        gantt.templates.task_cell_class = function (item, date) {
            if (date.getDay() == 0 || date.getDay() == 6) {
                return "weekend";
            }
        };
        

        function filter_tasks(node) {
            gantt_filter = node.value;
            //alert(gantt_filter);
            gantt.refreshData();
        }
       
        function filter_tasks2(node) {
            gantt_filter2 = node.value;
            //alert(gantt_filter2);
            gantt.refreshData();
        }
        
       
        function show_scale_options(mode) {
            var hourConf = document.getElementById("filter_hours"),
				dayConf = document.getElementById("filter_days");
            if (mode == 'day') {
                hourConf.style.display = "none";
                dayConf.style.display = "";
                dayConf.getElementsByTagName("input")[0].checked = true;
            } else if (mode == "hour") {
                hourConf.style.display = "";
                dayConf.style.display = "none";
                hourConf.getElementsByTagName("input")[0].checked = true;
            } else {
                hourConf.style.display = "none";
                dayConf.style.display = "none";
            }
            
        }
        function set_scale_units(mode) {
            if (mode && mode.getAttribute) {
                mode = mode.getAttribute("value");
            }

            switch (mode) {
                case "work_hours":
                    gantt.config.subscales = [
						{ unit: "hour", step: 1, date: "%H" }
                    ];
                    gantt.ignore_time = function (date) {
                        if (date.getHours() < 8 || date.getHours() > 17) {
                            return true;
                        } else {
                            return false;
                        }
                    };

                    break;
                case "full_day":
                    gantt.config.subscales = [
						{ unit: "hour", step: 3, date: "%H" }
                    ];
                    gantt.ignore_time = null;
                    break;
                case "work_week":
                    gantt.ignore_time = function (date) {
                        if (date.getDay() == 0 || date.getDay() == 6) {
                            return true;
                        } else {
                            return false;
                        }
                    };

                    break;
                default:
                    gantt.ignore_time = null;
                    break;
            }
            gantt.render();
        }
        function zoom_tasks(node) {
            switch (node.value) {
                case "week":
                    gantt.config.scale_unit = "day";
                    gantt.config.date_scale = "%d %M";

                    gantt.config.scale_height = 60;
                    gantt.config.min_column_width = 30;
                    gantt.config.subscales = [
  						  { unit: "hour", step: 1, date: "%H" }
                    ];
                    show_scale_options("hour");
                    break;
                case "trplweek":
                    gantt.config.min_column_width = 70;
                    gantt.config.scale_unit = "day";
                    gantt.config.date_scale = "%d %M %Y";
                    gantt.config.subscales = [];
                    gantt.config.scale_height = 35;
                    show_scale_options("day");
                    break;
                case "month":
                    gantt.config.min_column_width = 70;
                    gantt.config.scale_unit = "week";
                    gantt.config.date_scale = "Week #%W";
                    gantt.config.subscales = [
  						  { unit: "day", step: 1, date: "%D" }
                    ];
                    show_scale_options();
                    gantt.config.scale_height = 60;
                    break;
                case "year":
                    gantt.config.min_column_width = 70;
                    gantt.config.scale_unit = "month";
                    gantt.config.date_scale = "%M";
                    gantt.config.scale_height = 60;
                    show_scale_options();
                    gantt.config.subscales = [
  						  { unit: "week", step: 1, date: "#%W" }
                    ];
                    break;
                case "trplyear":
                    gantt.config.min_column_width = 70;
                    gantt.config.scale_unit = "year";
                    gantt.config.date_scale = "%Y";
                    gantt.config.scale_height = 60;
                    show_scale_options();
                    gantt.config.subscales = [
  						  { unit: "month", step: 1, date: "#%M" }
                    ];
                    break;
            }
            set_scale_units();
            gantt.render();
        }

        show_scale_options("day");
        gantt.config.details_on_create = true;

        gantt.templates.progress_text = function (start, end, task) {
            return "<span style='text-align:left;'>" + Math.round(task.progress*100) + "% </span>";
        };
        gantt.config.order_branch = true;
        var markerId = gantt.addMarker({
            start_date: new Date(), //a Date object that sets the marker's date
            css: "today", //a CSS class applied to the marker
            text: GetDateToday(), //the marker title
            title: GetDateToday() // the marker's tooltip
        });
        //gantt.config.tooltip_timeout = 50;
        //gantt.config.tooltip_hide_timeout = 5000;
        gantt.templates.tooltip_text = function(start,end,task){
            if(task.type == gantt.config.types.project)
            {
                var tekst;
                if (jezik == "en-US") {
                    tekst = "<b>Project:</b> "+task.text+"<br/><b>Start date:</b> " + 
                    GetDateLok(start)+ 
                    "<br/><b>End date:</b> "+GetDateLok(end);
                }
                else if (jezik == "es-ES") {
                    tekst = "<b>Proyecto:</b> "+task.text+"<br/><b>Fecha de inicio:</b> " + 
            GetDateLok(start)+ 
            "<br/><b>Fecha final:</b> "+GetDateLok(end);
                }
                else if (jezik == "de-DE") {
                    tekst = "<b>Projekt:</b> "+task.text+"<br/><b>Anfangsdatum:</b> " + 
            GetDateLok(start)+ 
            "<br/><b>Endtermin:</b> "+GetDateLok(end);
                } else if (jezik == "en-AU") {
                    tekst = "<b>Project:</b> "+task.text+"<br/><b>Start date:</b> " + 
GetDateLok(start) + 
"<br/><b>End date:</b> "+GetDateLok(end);
                } else if (jezik == "en-GB") {
                    tekst = "<b>Project:</b> "+task.text+"<br/><b>Start date:</b> " + 
GetDateLok(start) + 
"<br/><b>End date:</b> "+GetDateLok(end);
                }  else if (jezik == "sl-SI") {
                    tekst = "<b>Projekt:</b> "+task.text+"<br/><b>Začetni datum:</b> " + 
GetDateLok(start) + 
"<br/><b>Končni datum:</b> "+GetDateLok(end);
                }  else if (jezik == "it-IT") {
                    tekst = "<b>Progetto:</b> "+task.text+"<br/><b>Data d'inizio:</b> " + 
GetDateLok(start) + 
"<br/><b>Data di fine:</b> "+GetDateLok(end);
                }   else if (jezik == "sr-Latn-RS" || jezik == "hr-HR" || jezik == "bs-BS") {
                    tekst = "<b>Projekat:</b> "+task.text+"<br/><b>Početak:</b> " + 
            GetDateLok(start)+ 
            "<br/><b>Kraj:</b> "+GetDateLok(end);
                }
                return tekst;
            }
    
            if (jezik == "en-US") {
                return "<b>Task:</b> "+task.text+"<br/><b>Start date:</b> " + 
            GetDateLok(start)+ 
            "<br/><b>End date:</b> "+GetDateLok(end);
            }
            else if (jezik == "es-ES") {
                return "<b>Actividad:</b> "+task.text+"<br/><b>Fecha de inicio:</b> " + 
             GetDateLok(start)+ 
             "<br/><b>Fecha final:</b> "+GetDateLok(end);
            }
            else if (jezik == "de-DE") {
                return "<b>Aufgabe:</b> "+task.text+"<br/><b>Anfangsdatum:</b> " + 
             GetDateLok(start)+ 
             "<br/><b>Endtermin:</b> "+GetDateLok(end);
            } else if (jezik == "en-AU") {
                return "<b>Task:</b> "+task.text+"<br/><b>Start date:</b> " + 
             GetDateLok(start)+ 
             "<br/><b>End date:</b> "+GetDateLok(end);
            } else if (jezik == "sr-Latn-RS" || jezik == "hr-HR" || jezik == "bs-BS") {
                return "<b>Aktivnost:</b> "+task.text+"<br/><b>Početak:</b> " + 
            GetDateLok(start)+ 
            "<br/><b>Kraj:</b> "+GetDateLok(end);

            }
            else if (jezik == "en-GB") {
                return "<b>Task:</b> "+task.text+"<br/><b>Start date:</b> " + 
             GetDateLok(start)+ 
             "<br/><b>End date:</b> "+GetDateLok(end);
            } else if (jezik == "sl-SI") {
                return "<b>Dejavnost:</b> "+task.text+"<br/><b>Začetni datum:</b> " + 
             GetDateLok(start)+ 
             "<br/><b>Končni datum:</b> "+GetDateLok(end);
            } else if (jezik == "it-IT") {
                return "<b>Attività:</b> "+task.text+"<br/><b>Data d'inizio:</b> " + 
             GetDateLok(start)+ 
             "<br/><b>Data di fine:</b> "+GetDateLok(end);
            }
            
        };
        gantt.init("gantt_here");

        getact();
        var drag_id = null;
        
        function GetDateToday() {
            today = new Date();
            var dd = today.getDate();
            var mm = today.getMonth() + 1; //As January is 0.
            var yyyy = today.getFullYear();
            var datum = "";
            if (dd < 10) dd = '0' + dd;
            if (mm < 10) mm = '0' + mm;
            if (jezik == "en-US") {
                datum = "Now: " + mm + "/" + dd + "/" + yyyy;
            }
            else if (jezik == "de-DE") {
                datum = "Jetzt: " + dd + "." + mm + "." + yyyy;
            } else if (jezik == "es-ES") {
                datum = "Ahora: " + dd + "/" + mm + "/" + yyyy;
            } else if (jezik == "en-AU") {
                datum = "Now: " + dd + "/" + mm + "/" + yyyy;
            } else if (jezik == "sr-Latn-RS" || jezik == "hr-HR" || jezik == "bs-BS") {
                datum = "Sada: " + dd + "." + mm + "." + yyyy;

            }else if (jezik == "en-GB") {
                datum = "Now: " + dd + "/" + mm + "/" + yyyy;
            } 
            else if (jezik == "sl-SI") {
                datum = "Zdaj: " + dd + "." + mm + "." + yyyy;
            } 
            else if (jezik == "it-IT") {
                datum = "Adesso: " + dd + "." + mm + "." + yyyy;
            } 
            return datum;
        };
        function GetDateLok(dat) {
            today = dat;
            var dd = today.getDate();
            var mm = today.getMonth()+1; //As January is 0.
            var yyyy = today.getFullYear();
            var datum = "";
            if (dd < 10) dd = '0' + dd;
            if (mm < 10) mm = '0' + mm;
            if (jezik == "en-US") {
                datum = "Now: " + mm + "/" + dd + "/" + yyyy;
            }
            else if (jezik == "es-ES") {
                datum = dd + "." + mm + "." + yyyy;
            } 
            else if (jezik == "de-DE") {
                datum = dd + "." + mm + "." + yyyy;
            } else if (jezik == "en-AU") {
                datum = dd + "/" + mm + "/" + yyyy;
            } else if (jezik == "sr-Latn-RS" || jezik == "hr-HR" || jezik == "bs-BS") {
                datum = dd + "." + mm + "." + yyyy;

            }
            else if (jezik == "en-GB") {
                datum = dd + "/" + mm + "/" + yyyy;
            }
            else if (jezik == "sl-SI") {
                datum = dd + "." + mm + "." + yyyy;
            }
            else if (jezik == "it-IT") {
                datum = dd + "." + mm + "." + yyyy;
            }
            return datum;
        };
        function updateCriticalPath(toggle) {
            gantt.config.highlight_critical_path = !gantt.config.highlight_critical_path;
            if (gantt.config.highlight_critical_path) {
                if (jezik == "en-US") {
                    toggle.innerHTML = "Hide Critical Path";
                }
                else if (jezik == "de-DE") {
                    toggle.innerHTML = "Kritischen Pfad ausblenden";
                }  else if (jezik == "es-ES") {
                    toggle.innerHTML = "Ocultar ruta crítica";
                } else if (jezik == "en-AU") {
                    toggle.innerHTML = "Hide Critical Path";
                } else if (jezik == "sr-Latn-RS" || jezik == "hr-HR" || jezik == "bs-BS") {
                    toggle.innerHTML = "Sakrij kritični put";

                } else if (jezik == "en-GB") {
                    toggle.innerHTML = "Hide Critical Path";
                } 
                else if (jezik == "sl-SI") {
                    toggle.innerHTML = "Skrij kritično pot";
                }  else if (jezik == "it-IT") {
                    toggle.innerHTML = "Nascondi percorso critico";
                } 
                gantt.config.highlight_critical_path = true;
                gantt.render();
            } else {
                if (jezik == "en-US") {
                    toggle.innerHTML = "Show Critical Path";
                }  else if (jezik == "es-ES") {
                    toggle.innerHTML = "Mostrar ruta crítica";
                }
                else if (jezik == "de-DE") {
                    toggle.innerHTML = "Kritischen Pfad anzeigen";
                } else if (jezik == "en-AU") {
                    toggle.innerHTML = "Show Critical Path";
                } else if (jezik == "sr-Latn-RS" || jezik == "hr-HR" || jezik == "bs-BS") {
                    toggle.innerHTML = "Pokaži kritični put";

                }
                else if (jezik == "en-GB") {
                    toggle.innerHTML = "Show Critical Path";
                }
                else if (jezik == "sl-SI") {
                    toggle.innerHTML = "Prikaži kritično pot";
                }
                else if (jezik == "it-IT") {
                    toggle.innerHTML = "Mostra percorso critico";
                }
                gantt.config.highlight_critical_path = false;
                gantt.render();
            }
            
        }
        function success(data) {
            //console.log(data);
            gantt.parse(data.Message);
          
        }
        function successUpdate(data) {
            var str = data.Message.split(';');
            var newid = parseInt(str[0])
            var task2 = gantt.getTask(newid);
            task2.assigned = str[1];
            gantt.refreshData();
        
        }
        function successDelete(data) {
            alert(data.Message);
        }
        function successDeleteLink(data) {
            //alert(data.Message);
        }
        function errorDeleteLink(data) {
            //alert(data.Message);
        }
        function successDelete(data) {
            //alert(data.Message);
        }
        function successInsert(data) {
            var str=data.Message.split(';');
            var newid = parseInt(str[0])
            var id = parseInt(str[1]);
            gantt.changeTaskId(id, newid);
            var task2 = gantt.getTask(newid);
            task2.assigned = str[2];
            gantt.refreshData();
        }
        function error() {

        }
        gantt.showLightbox = function (id) {
            taskId = id;
            var task = gantt.getTask(id);
            if (task.type != gantt.config.types.project) {
                if (task.id>1000000000) {
                    openRadWindow(0);
                }
                else {
                    openRadWindow(taskId);

                }
            }
       
        };
        function Search_Click(sender, args) {
            //alert('Usao');
            //sender.cancel(true);
            var tekstbox = document.getElementById("searchBoxtask");
            var tekst = tekstbox.value;
            //alert(tekst);  
            if (tekst == null || tekst=="")
            {
                gantt_filter3 = "0";
            }
            else
            {
                gantt_filter3 = tekst;
            }
            //alert(gantt_filter3);
            gantt.refreshData();
        }

        function MyBlur(sender,args)
        {
            gantt.refreshData();


        }
        function OnClientItemChecked(radComboBox, eventArgs) {
            var filtertekst=eventArgs.get_item().get_value();

            var allItems = radComboBox.get_items();
            var allNumber = radComboBox.get_items().get_count();
            
            gantt_filter1 = filtertekst;
         
            for (var i = 0; i < allNumber; i++)
            {
                if(allItems.getItem(i).get_value()==filtertekst)
                {
                    
                    allItems.getItem(i).set_checked(true);
                }
                else
                {
                    allItems.getItem(i).set_checked(false);
                }
            }
           
         
        }
            
           

        function getact() {
     
            PageMethods.GetActivities(Idproject, success, error);
           
        
        }
        function successInsertLink(data) {
            var str = data.Message.split(';');
            var newid = parseInt(str[0])
            var id = parseInt(str[1]);
            //Kod za izmjenu link id-ja kada se vrati iz baze gantt.changeLinkId(1274, "link14"); 
            gantt.changeLinkId(id, newid);
            gantt.refreshData();
        }
        function errorInsertLink() {

        }
        function deleteTaskbaza(id) {
            PageMethods.DeleteActivities(id, successDelete, error);
        }
        function insertLinkbaza(link)
        {
            if (link.id > 1000000000) {
                //Pozovi page method openRadWindow(0);
                var veza = "'id';" + 0 + ";'source';" + link.source + ";'target';" + link.target + ";'type';" + link.type+";'ganttId';"+link.id;
                PageMethods.InsertLink(veza, successInsertLink, errorInsertLink);
            }
           
        }
        function deleteLinkbaza(id) {
            //Pozovi page method openRadWindow(0);
                
            PageMethods.DeleteLink(id, successDeleteLink, errorDeleteLink);
        }

        function updateTaskbaza(task) {
           
            var parentactivity = gantt.getTask(task.parent);
            if (parentactivity.type != gantt.config.types.project)
            {
                //alert(task.Id);
                var activity = "'id';" + task.id + ";'text';" + task.text + ";'start_date';" + formatFunc(task.start_date) + ";'duration';" + task.duration + ";'parent';" + task.parent + ";'progress';" + parseFloat(task.progress).toFixed(4) + ";'priority';" + task.priority + ";'assigned';" + task.assigned + ";'description';" + /*task.description*/"' '" + ";'projectId';" + Idproject;
            }
            else
            {
                //alert(0);
                var activity = "'id';" + task.id + ";'text';" + task.text + ";'start_date';" + formatFunc(task.start_date) + ";'duration';" + task.duration + ";'parent';" + "0" + ";'progress';" + parseFloat(task.progress).toFixed(4) + ";'priority';" + task.priority + ";'assigned';" + task.assigned + ";'description';" + /*task.description*/"' '" + ";'projectId';" + Idproject;
            }
            PageMethods.UpdateActivities(activity, successUpdate, error);
        }
        var formatFunc = gantt.date.date_to_str("%Y-%m-%d %H:%m");
        function insertTaskbaza(task) {
            var activity = "'id';0;'text';" + task.text + ";'start_date';" + formatFunc(task.start_date) + ";'duration';" + task.duration + ";'parent';" + task.parent + ";'progress';" + task.progress + ";'priority';" + task.priority + ";'assigned';" + task.assigned + ";'description';" + task.description + ";'projectId';" + Idproject+";'ganttId';"+task.id;
            PageMethods.InsertActivities(activity, successInsert, error);
        }
        function otvoriSve() {
            gantt.eachTask(function (task) {
                task.$open = true;
            });
            gantt.render();
        }
        function zatvoriSve() {
            gantt.eachTask(function (task) {
                task.$open = false;
            });
            gantt.render();
        }
        gantt.ext.tooltips.tooltipFor({
            selector: ".gantt_row",
            html: function(event, domElement){
                return ""
            }
        });

        gantt.attachEvent("onAfterTaskDrag", function (id, mode, e) {
            var task = gantt.getTask(id);
            var right = document.getElementById('MainContentPlaceHolder_Content_hdnRoles').value;
            //alert(right);
            if (task.type == gantt.config.types.project || right != "2") {
                return false;
            }
            else {
                //alert('azuriram');
                updateTaskbaza(task);
            }
            return true;
        });
        gantt.attachEvent("onBeforeTaskDrag", function (id, mode, e) {
            var task = gantt.getTask(id);
            var right = document.getElementById('MainContentPlaceHolder_Content_hdnRoles').value;
            //alert(right);
            if (task.type == gantt.config.types.project || right != "2") {
                return false;
            }
            else 
            {
       
                return true;
            }
            //
        });
       
        // links
	
        gantt.attachEvent('onBeforeLinkAdd', function (id, link) {
            //alert(id);
            //alert(link);
            var right = document.getElementById('MainContentPlaceHolder_Content_hdnRoles').value;
            if (right != "2") {
                return false;
            }
            else {
                insertLinkbaza(link);
            }
        });
	
        gantt.attachEvent('onBeforeLinkDelete', function (id, link) {
            var right = document.getElementById('MainContentPlaceHolder_Content_hdnRoles').value;
            if (right != "2") {
                return false;
            }
            else {
                deleteLinkbaza(id);
            }
        });
        var exportTo = function () {
            var output = document.getElementById("export").value;
            switch (output) {
                case "pdf": gantt.exportToPDF(); break;
                case "png": gantt.exportToPNG(); break;
                case "excel": gantt.exportToExcel(); break;
                case "ical": gantt.exportToICal(); break;
                default: alert("Wrong file format");
            }
        };
        //<!-- GANT KRAJ-->	
	
        //PROZOR
        var $ = $telerik.$;
        $(document).on('click', '.radGrid', function (e) {
            var $element = $(e.target);
            $element = $element.parents("td[role = 'gridcell']").first();;
            var indeks = $element.index();
            if (indeks === 0) {
                var tas = $element.text();
                var ordnumber = document.getElementById('MainContentPlaceHolder_Content_hdnOrdNum');
                ordnumber.value = tas;
                var radwindow = document.getElementById('ctl00_ctl00_MainContentPlaceHolder_Content_RadWindow1');
                var url = "../Pages/GanttActivity.aspx?ordnumb=" + tas;
                radwindow.setAttribute("NavigateUrl", url);
                eventHandler();

            }
        });
        function eventHandler() {

            $("#MainContentPlaceHolder_Content_Button1").click();

        }
        function openRadWindow(taskId) {
            //alert('Poceo otvaranje');
            var manager = GetRadWindowManager();
            //alert('Nasao menagera');
            var url = "../Pages/GanttActivity.aspx?ordnumb=" + taskId+'&gant=1';
            //if (GetRadWindowManager().getActiveWindow() != null) {
            var radwindow = manager.getWindowByName("RadWindow1");
            if (radwindow!=null)
            {
                radwindow.setUrl(url);
                radwindow.show();

                if (radwindow.isVisible) {
                    //obtain the necessary values - percent and viewport size
                    var value = $telerik.$("#wndPercentageValue").attr("value");
                    var browserWidth = $telerik.$(window).width();
                    var browserHeight = $telerik.$(window).height();
                    //resize the RadWindow
                    radwindow.setSize(Math.ceil(browserWidth * value / 100), "650px");

                    //optionally you may also center the RadWindow
                    //otherwise it will stay where the original calculation for its top left corner leaves it
                    radwindow.center();
                }
                //setTimeout(function () { closeWin() }, 50);
                var expireTime = <%= FormsAuthentication.Timeout.TotalMinutes %>;
	            setTimeout(closeWin, expireTime*60*1000);
            }
            return false;
	    //}
	    //return false;
        }
        function closeWin() {
            //GetRadWindow().BrowserWindow.location.href = 'Default2.aspx';
            GetRadWindow().close();
        }
        function GetRadWindow() {
            var oWindow = null;
            var manager = GetRadWindowManager();
            var radwindow = manager.getWindowByName("RadWindow1");
            if (radwindow != null) {
                oWindow = radwindow;
            }
            return oWindow;
        }
        //function RefreshParentPageWindow() {
        //    var urla = document.location.href;
        //    var n = urla.indexOf('?');
        //    var newUrl = urla.substring(0, n);
        //    window.location.replace(newUrl);
        //}
        function RefreshParentPage() {

            location.reload();
        }
        //PROZOR KRAJ
    </script>

</asp:Content>

